<?php
require_once dirname(__DIR__) . '/config/db.php';

try {
    // Check if permission already exists
    $stmt = $pdo->prepare("SELECT id FROM permissions WHERE name = ?");
    $stmt->execute(['view_products']);
    if (!$stmt->fetch()) {
        // Add the permission
        $stmt = $pdo->prepare("INSERT INTO permissions (name, description) VALUES (?, ?)");
        $stmt->execute([
            'view_products',
            'Can view and manage products'
        ]);
        echo "Successfully added view_products permission\n";
    } else {
        echo "Permission view_products already exists\n";
    }
} catch (PDOException $e) {
    echo "Error: " . $e->getMessage() . "\n";
} 